# Fix all Vue files to use correct isDarkMode type

$files = @(
    "resources\js\Components\CategoryGrid.vue",
    "resources\js\Components\CityCard.vue",
    "resources\js\Components\EventCard.vue",
    "resources\js\Components\Footer.vue",
    "resources\js\Components\HeroSearch.vue",
    "resources\js\Components\ListingCard.vue",
    "resources\js\Components\NewsCard.vue",
    "resources\js\Components\NewsletterBox.vue",
    "resources\js\Components\TestimonialCard.vue",
    "resources\js\Pages\Landing\Attractions.vue",
    "resources\js\Pages\Landing\Cities.vue",
    "resources\js\Pages\Landing\Contact.vue",
    "resources\js\Pages\Landing\Events.vue",
    "resources\js\Pages\Landing\Explore.vue",
    "resources\js\Pages\Landing\Visit.vue"
)

foreach ($file in $files) {
    $fullPath = "c:\wamp64\www\exploregreene\$file"
    if (Test-Path $fullPath) {
        $content = Get-Content $fullPath -Raw

        # Replace inject import to include Ref and ref (multiple patterns)
        $content = $content -replace "import \{ inject \} from 'vue'", "import { inject } from 'vue'"
        $content = $content -replace "import \{ inject, computed \} from 'vue'", "import { inject, computed } from 'vue'"

        # Remove .value from isDarkMode in template
        $content = $content -replace "isDarkMode\.value", "isDarkMode"

        # Replace isDarkMode inject to NOT use Ref (since we're not using .value)
        $content = $content -replace "const isDarkMode = inject<Ref<boolean>>\('isDarkMode', ref\(false\)\)", "const isDarkMode = inject('isDarkMode', false)"
