<?php

/**
 * Static data for Greene County events
 * Used for public-facing pages
 */

return [
    'upcoming' => [
        [
            'id' => 1,
            'title' => 'Spring Wine Festival',
            'date' => '2025-04-15',
            'endDate' => '2025-04-17',
            'image' => 'https://images.unsplash.com/photo-1510812431401-41d2cab2707d?w=600&h=400&fit=crop',
            'description' => 'Celebrate spring with local wines and gourmet food pairings.',
            'location' => 'Downtown Greene County',
            'category' => 'festival',
        ],
        [
            'id' => 2,
            'title' => 'Mountain Music Concert Series',
            'date' => '2025-05-01',
            'endDate' => '2025-05-01',
            'image' => 'https://images.unsplash.com/photo-1459749411175-04bf5292ceea?w=600&h=400&fit=crop',
            'description' => 'Live bluegrass and country music performances.',
            'location' => 'Heritage Park',
            'category' => 'music',
        ],
        [
            'id' => 3,
            'title' => 'Summer Farmers Market',
            'date' => '2025-06-01',
            'endDate' => '2025-08-31',
            'image' => 'https://images.unsplash.com/photo-1488459716781-6f8ee36f7b94?w=600&h=400&fit=crop',
            'description' => 'Weekly markets with fresh local produce and crafts.',
            'location' => 'Central Plaza',
            'category' => 'market',
        ],
        [
            'id' => 4,
            'title' => 'Fall Foliage Festival',
            'date' => '2025-10-01',
            'endDate' => '2025-10-15',
            'image' => 'https://images.unsplash.com/photo-1507003211169-0a1dd7228f2d?w=600&h=400&fit=crop',
            'description' => 'Celebrate autumn with leaf tours and local activities.',
            'location' => 'Greene County Parks',
            'category' => 'festival',
        ],
    ],

    'featured' => [
        [
            'id' => 1,
            'name' => 'Blue Ridge Mountain Festival',
            'slug' => 'blue-ridge-mountain-festival',
            'title' => 'Blue Ridge Mountain Festival',
            'date' => '2025-06-15',
            'image' => 'https://images.unsplash.com/photo-1510812431401-41d2cab2707d?w=600&h=400&fit=crop',
            'description' => '3-day festival featuring live music, food vendors, and arts & crafts.',
            'price' => '$15-35/day',
            'rating' => 4.8,
            'reviews_count' => 642,
            'featured' => true,
        ],
        [
            'id' => 2,
            'name' => 'Wine & Food Pairing Dinner',
            'slug' => 'wine-food-pairing-dinner',
            'title' => 'Wine & Food Pairing Dinner',
            'date' => '2025-07-20',
            'image' => 'https://images.unsplash.com/photo-1459749411175-04bf5292ceea?w=600&h=400&fit=crop',
            'description' => '5-course menu with wine pairing at Early Mountain Vineyards.',
            'price' => '$85/person',
            'rating' => 4.9,
            'reviews_count' => 189,
            'featured' => true,
        ],
        [
            'id' => 3,
            'name' => 'Summer Farmers Market',
            'slug' => 'summer-farmers-market',
            'title' => 'Summer Farmers Market',
            'date' => '2025-06-01',
            'image' => 'https://images.unsplash.com/photo-1488459716781-6f8ee36f7b94?w=600&h=400&fit=crop',
            'description' => 'Weekly markets with fresh local produce and crafts.',
            'price' => 'Free',
            'rating' => 4.7,
            'reviews_count' => 445,
            'featured' => true,
        ],
    ],

    'categories' => [
        'festival' => 'Festivals',
        'music' => 'Music & Concerts',
        'market' => 'Markets',
        'sports' => 'Sports & Outdoors',
        'cultural' => 'Cultural Events',
        'family' => 'Family Activities',
    ],
];
