import { defineComponent, inject, computed, ref, onMounted, onUnmounted, mergeProps, unref, nextTick, useSSRContext, withCtx, createVNode, createBlock, createCommentVNode, openBlock, toDisplayString } from "vue";
import { ssrRenderAttrs, ssrRenderList, ssrRenderStyle, ssrRenderAttr, ssrInterpolate, ssrRenderClass, ssrRenderComponent } from "vue/server-renderer";
import { Link, Head } from "@inertiajs/vue3";
import { _ as _export_sfc } from "./_plugin-vue_export-helper-1tPrXgE0.js";
const _sfc_main$8 = /* @__PURE__ */ defineComponent({
  __name: "HeroSlider",
  __ssrInlineRender: true,
  props: {
    slides: {},
    autoPlayInterval: {}
  },
  setup(__props) {
    const isDarkMode = inject("isDarkMode", computed(() => false));
    const props = __props;
    const currentSlide = ref(0);
    const autoPlayTimer = ref(null);
    const videoElement = ref(null);
    const isVideoPlaying = ref(false);
    const nextSlide = () => {
      currentSlide.value = (currentSlide.value + 1) % props.slides.length;
    };
    const startAutoPlay = () => {
      if (props.autoPlayInterval && props.autoPlayInterval > 0 && !isVideoPlaying.value) {
        autoPlayTimer.value = window.setInterval(() => {
          nextSlide();
        }, props.autoPlayInterval);
      }
    };
    const stopAutoPlay = () => {
      if (autoPlayTimer.value) {
        clearInterval(autoPlayTimer.value);
        autoPlayTimer.value = null;
      }
    };
    const playVideoSlide = async () => {
      await nextTick();
      if (videoElement.value && props.slides[currentSlide.value]?.isVideo) {
        videoElement.value.play().catch(() => {
          console.log("Auto-play prevented, user interaction required");
        });
      }
    };
    onMounted(() => {
      startAutoPlay();
      playVideoSlide();
    });
    onUnmounted(() => {
      stopAutoPlay();
    });
    return (_ctx, _push, _parent, _attrs) => {
      _push(`<section${ssrRenderAttrs(mergeProps({ class: "relative h-[600px] md:h-[700px] overflow-hidden" }, _attrs))} data-v-d056b5d3><!--[-->`);
      ssrRenderList(__props.slides, (slide, index) => {
        _push(`<div class="absolute inset-0" style="${ssrRenderStyle(index === currentSlide.value ? null : { display: "none" })}" data-v-d056b5d3>`);
        if (slide.isVideo && slide.video) {
          _push(`<div class="absolute inset-0" data-v-d056b5d3><video${ssrRenderAttr("src", slide.video)} class="w-full h-full object-cover" autoplay muted playsinline data-v-d056b5d3></video><div class="absolute inset-0 bg-gradient-to-r from-black/40 via-black/20 to-transparent" data-v-d056b5d3></div></div>`);
        } else {
          _push(`<div class="absolute inset-0 bg-cover bg-center" style="${ssrRenderStyle({ backgroundImage: `url(${slide.image})` })}" data-v-d056b5d3><div class="absolute inset-0 bg-gradient-to-r from-black/70 via-black/50 to-transparent" data-v-d056b5d3></div></div>`);
        }
        _push(`<div class="relative h-full max-w-7xl mx-auto px-4 flex items-center" data-v-d056b5d3><div class="max-w-2xl text-white space-y-6 animate-fade-in" data-v-d056b5d3><h1 class="text-4xl md:text-6xl font-bold leading-tight" data-v-d056b5d3>${ssrInterpolate(slide.title)}</h1><p class="text-xl md:text-2xl text-gray-200" data-v-d056b5d3>${ssrInterpolate(slide.subtitle)}</p>`);
        if (slide.cta && slide.ctaLink) {
          _push(`<div class="pt-4" data-v-d056b5d3><a${ssrRenderAttr("href", slide.ctaLink)} class="inline-block bg-red-600 hover:bg-red-700 text-white font-semibold px-8 py-4 rounded-lg transition-all duration-300 transform hover:scale-105" data-v-d056b5d3>${ssrInterpolate(slide.cta)}</a></div>`);
        } else {
          _push(`<!---->`);
        }
        _push(`</div></div>`);
        if (slide.isVideo && isVideoPlaying.value) {
          _push(`<div class="absolute top-8 right-8 z-20" data-v-d056b5d3><button class="bg-red-600 hover:bg-red-700 text-white font-semibold px-6 py-2 rounded-lg transition-all duration-300 transform hover:scale-105 flex items-center gap-2" data-v-d056b5d3><svg class="w-5 h-5" fill="none" stroke="currentColor" viewBox="0 0 24 24" data-v-d056b5d3><path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M9 5l7 7-7 7" data-v-d056b5d3></path></svg> Skip </button></div>`);
        } else {
          _push(`<!---->`);
        }
        _push(`</div>`);
      });
      _push(`<!--]--><button class="absolute left-4 top-1/2 -translate-y-1/2 z-10 bg-white/20 hover:bg-white/30 backdrop-blur-sm text-white p-3 rounded-full transition-all duration-300" aria-label="Previous Slide" data-v-d056b5d3><svg class="w-6 h-6" fill="none" stroke="currentColor" viewBox="0 0 24 24" data-v-d056b5d3><path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M15 19l-7-7 7-7" data-v-d056b5d3></path></svg></button><button class="absolute right-4 top-1/2 -translate-y-1/2 z-10 bg-white/20 hover:bg-white/30 backdrop-blur-sm text-white p-3 rounded-full transition-all duration-300" aria-label="Next Slide" data-v-d056b5d3><svg class="w-6 h-6" fill="none" stroke="currentColor" viewBox="0 0 24 24" data-v-d056b5d3><path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M9 5l7 7-7 7" data-v-d056b5d3></path></svg></button><div class="absolute bottom-8 left-1/2 -translate-x-1/2 z-10 flex gap-3" data-v-d056b5d3><!--[-->`);
      ssrRenderList(__props.slides, (slide, index) => {
        _push(`<button class="${ssrRenderClass([index === currentSlide.value ? "w-12 h-3 bg-white rounded-full" : "w-3 h-3 bg-white/50 hover:bg-white/70 rounded-full", "transition-all duration-300"])}"${ssrRenderAttr("aria-label", `Go to slide ${index + 1}`)} data-v-d056b5d3></button>`);
      });
      _push(`<!--]--></div><div class="absolute bottom-0 left-0 right-0 z-10 pb-20" data-v-d056b5d3><div class="max-w-4xl mx-auto px-4" data-v-d056b5d3><div class="${ssrRenderClass([unref(isDarkMode) ? "bg-gray-900/80" : "bg-white/90", "backdrop-blur-md rounded-2xl shadow-2xl p-6 transition-colors duration-300"])}" data-v-d056b5d3><div class="flex flex-col md:flex-row gap-4" data-v-d056b5d3><div class="flex-1" data-v-d056b5d3><input type="text" placeholder="What are you looking for?" class="${ssrRenderClass([unref(isDarkMode) ? "bg-gray-800 border-gray-700 text-white placeholder-gray-400" : "bg-white border-gray-200 text-gray-900 placeholder-gray-500", "w-full px-4 py-3 rounded-lg border-2 focus:ring-2 focus:ring-red-500 focus:border-transparent transition-all duration-300"])}" data-v-d056b5d3></div><div class="flex-1" data-v-d056b5d3><select class="${ssrRenderClass([unref(isDarkMode) ? "bg-gray-800 border-gray-700 text-white" : "bg-white border-gray-200 text-gray-900", "w-full px-4 py-3 rounded-lg border-2 focus:ring-2 focus:ring-red-500 focus:border-transparent transition-all duration-300"])}" data-v-d056b5d3><option value="" data-v-d056b5d3>All Locations</option><option value="stanardsville" data-v-d056b5d3>Stanardsville</option><option value="ruckersville" data-v-d056b5d3>Ruckersville</option><option value="dyke" data-v-d056b5d3>Dyke</option><option value="quinque" data-v-d056b5d3>Quinque</option><option value="mcmullen" data-v-d056b5d3>McMullen</option><option value="lydia" data-v-d056b5d3>Lydia</option></select></div><button class="bg-red-600 hover:bg-red-700 text-white font-semibold px-8 py-3 rounded-lg transition-all duration-300 transform hover:scale-105" data-v-d056b5d3> Search </button></div></div></div></div></section>`);
    };
  }
});
const _sfc_setup$8 = _sfc_main$8.setup;
_sfc_main$8.setup = (props, ctx) => {
  const ssrContext = useSSRContext();
  (ssrContext.modules || (ssrContext.modules = /* @__PURE__ */ new Set())).add("resources/js/Components/HeroSlider.vue");
  return _sfc_setup$8 ? _sfc_setup$8(props, ctx) : void 0;
};
const HeroSlider = /* @__PURE__ */ _export_sfc(_sfc_main$8, [["__scopeId", "data-v-d056b5d3"]]);
const _sfc_main$7 = /* @__PURE__ */ defineComponent({
  __name: "CategoryGrid",
  __ssrInlineRender: true,
  props: {
    categories: {}
  },
  setup(__props) {
    const isDarkMode = inject("isDarkMode", computed(() => false));
    return (_ctx, _push, _parent, _attrs) => {
      _push(`<section${ssrRenderAttrs(mergeProps({
        class: ["py-16 transition-colors duration-300", unref(isDarkMode) ? "bg-gray-900" : "bg-gray-50"]
      }, _attrs))} data-v-da1ac888><div class="max-w-7xl mx-auto px-4" data-v-da1ac888><div class="text-center mb-12" data-v-da1ac888><h2 class="${ssrRenderClass([unref(isDarkMode) ? "text-white" : "text-gray-900", "text-3xl md:text-4xl font-bold mb-2 transition-colors duration-300"])}" data-v-da1ac888> Hot &amp; Trending <span class="text-red-600" data-v-da1ac888>Categories</span></h2><p class="${ssrRenderClass([unref(isDarkMode) ? "text-gray-400" : "text-gray-600", "text-lg transition-colors duration-300"])}" data-v-da1ac888> Explore the most popular categories to add your listings </p></div><div class="grid grid-cols-2 md:grid-cols-3 lg:grid-cols-6 gap-4" data-v-da1ac888><!--[-->`);
      ssrRenderList(__props.categories, (category) => {
        _push(ssrRenderComponent(unref(Link), {
          key: category.id,
          href: category.route,
          as: "a",
          class: ["rounded-lg shadow-md hover:shadow-lg transition duration-300 p-6 text-center cursor-pointer transform hover:scale-105 block", unref(isDarkMode) ? "bg-gray-800 hover:bg-gray-700" : "bg-white hover:bg-gray-50"]
        }, {
          default: withCtx((_, _push2, _parent2, _scopeId) => {
            if (_push2) {
              _push2(`<div class="mb-3 flex justify-center" data-v-da1ac888${_scopeId}><div class="${ssrRenderClass(`w-16 h-16 rounded-full flex items-center justify-center text-2xl bg-${category.color}-100`)}" data-v-da1ac888${_scopeId}>`);
              if (category.icon === "map-pin") {
                _push2(`<span data-v-da1ac888${_scopeId}>📍</span>`);
              } else if (category.icon === "utensils") {
                _push2(`<span data-v-da1ac888${_scopeId}>🍽️</span>`);
              } else if (category.icon === "calendar") {
                _push2(`<span data-v-da1ac888${_scopeId}>📅</span>`);
              } else if (category.icon === "leaf") {
                _push2(`<span data-v-da1ac888${_scopeId}>🌿</span>`);
              } else if (category.icon === "shopping-bag") {
                _push2(`<span data-v-da1ac888${_scopeId}>🛍️</span>`);
              } else if (category.icon === "landmark") {
                _push2(`<span data-v-da1ac888${_scopeId}>🏛️</span>`);
              } else {
                _push2(`<!---->`);
              }
              _push2(`</div></div><h3 class="${ssrRenderClass([unref(isDarkMode) ? "text-white" : "text-gray-900", "font-semibold mb-2 transition-colors duration-300"])}" data-v-da1ac888${_scopeId}>${ssrInterpolate(category.name)}</h3><p class="${ssrRenderClass([unref(isDarkMode) ? "text-gray-400" : "text-gray-600", "text-sm transition-colors duration-300"])}" data-v-da1ac888${_scopeId}>${ssrInterpolate(category.count)} listings </p>`);
            } else {
              return [
                createVNode("div", { class: "mb-3 flex justify-center" }, [
                  createVNode("div", {
                    class: `w-16 h-16 rounded-full flex items-center justify-center text-2xl bg-${category.color}-100`
                  }, [
                    category.icon === "map-pin" ? (openBlock(), createBlock("span", { key: 0 }, "📍")) : category.icon === "utensils" ? (openBlock(), createBlock("span", { key: 1 }, "🍽️")) : category.icon === "calendar" ? (openBlock(), createBlock("span", { key: 2 }, "📅")) : category.icon === "leaf" ? (openBlock(), createBlock("span", { key: 3 }, "🌿")) : category.icon === "shopping-bag" ? (openBlock(), createBlock("span", { key: 4 }, "🛍️")) : category.icon === "landmark" ? (openBlock(), createBlock("span", { key: 5 }, "🏛️")) : createCommentVNode("", true)
                  ], 2)
                ]),
                createVNode("h3", {
                  class: ["font-semibold mb-2 transition-colors duration-300", unref(isDarkMode) ? "text-white" : "text-gray-900"]
                }, toDisplayString(category.name), 3),
                createVNode("p", {
                  class: ["text-sm transition-colors duration-300", unref(isDarkMode) ? "text-gray-400" : "text-gray-600"]
                }, toDisplayString(category.count) + " listings ", 3)
              ];
            }
          }),
          _: 2
        }, _parent));
      });
      _push(`<!--]--></div></div></section>`);
    };
  }
});
const _sfc_setup$7 = _sfc_main$7.setup;
_sfc_main$7.setup = (props, ctx) => {
  const ssrContext = useSSRContext();
  (ssrContext.modules || (ssrContext.modules = /* @__PURE__ */ new Set())).add("resources/js/Components/CategoryGrid.vue");
  return _sfc_setup$7 ? _sfc_setup$7(props, ctx) : void 0;
};
const CategoryGrid = /* @__PURE__ */ _export_sfc(_sfc_main$7, [["__scopeId", "data-v-da1ac888"]]);
const _sfc_main$6 = /* @__PURE__ */ defineComponent({
  __name: "ListingCard",
  __ssrInlineRender: true,
  props: {
    listings: {},
    title: {},
    subtitle: {}
  },
  setup(__props) {
    const isDarkMode = inject("isDarkMode", computed(() => false));
    return (_ctx, _push, _parent, _attrs) => {
      _push(`<section${ssrRenderAttrs(mergeProps({
        class: ["py-16 transition-colors duration-300", unref(isDarkMode) ? "bg-gray-900" : "bg-white"]
      }, _attrs))} data-v-a0c532e2><div class="max-w-7xl mx-auto px-4" data-v-a0c532e2>`);
      if (__props.title) {
        _push(`<div class="text-center mb-12" data-v-a0c532e2><h2 class="${ssrRenderClass([unref(isDarkMode) ? "text-white" : "text-gray-900", "text-3xl md:text-4xl font-bold mb-2 transition-colors duration-300"])}" data-v-a0c532e2>${ssrInterpolate(__props.title)} `);
        if (__props.title.includes("Popular")) {
          _push(`<span class="text-red-600" data-v-a0c532e2>Listings</span>`);
        } else {
          _push(`<!---->`);
        }
        _push(`</h2>`);
        if (__props.subtitle) {
          _push(`<p class="${ssrRenderClass([unref(isDarkMode) ? "text-gray-400" : "text-gray-600", "text-lg transition-colors duration-300"])}" data-v-a0c532e2>${ssrInterpolate(__props.subtitle)}</p>`);
        } else {
          _push(`<!---->`);
        }
        _push(`</div>`);
      } else {
        _push(`<!---->`);
      }
      _push(`<div class="grid grid-cols-1 md:grid-cols-2 lg:grid-cols-4 gap-6" data-v-a0c532e2><!--[-->`);
      ssrRenderList(__props.listings, (listing) => {
        _push(ssrRenderComponent(unref(Link), {
          key: listing.id,
          href: listing.slug ? `/attractions/${listing.slug}` : "#",
          class: ["bg-white rounded-lg overflow-hidden shadow-md hover:shadow-xl transition duration-300 transform hover:scale-105 cursor-pointer group", unref(isDarkMode) ? "bg-gray-800" : "bg-white"]
        }, {
          default: withCtx((_, _push2, _parent2, _scopeId) => {
            if (_push2) {
              _push2(`<div class="relative overflow-hidden h-48 bg-gray-200" data-v-a0c532e2${_scopeId}><img${ssrRenderAttr("src", listing.image)}${ssrRenderAttr("alt", listing.name || listing.title)} class="w-full h-full object-cover group-hover:scale-110 transition duration-300" loading="lazy" data-v-a0c532e2${_scopeId}><div class="absolute top-3 right-3 bg-gray-800 text-white px-3 py-1 rounded-full text-sm capitalize" data-v-a0c532e2${_scopeId}>${ssrInterpolate(listing.category)}</div></div><div class="p-4" data-v-a0c532e2${_scopeId}><h3 class="${ssrRenderClass([unref(isDarkMode) ? "text-white" : "text-gray-900", "text-lg font-bold mb-2 line-clamp-2 transition-colors duration-300"])}" data-v-a0c532e2${_scopeId}>${ssrInterpolate(listing.name || listing.title)}</h3><p class="${ssrRenderClass([unref(isDarkMode) ? "text-gray-400" : "text-gray-600", "text-sm mb-4 line-clamp-2 transition-colors duration-300"])}" data-v-a0c532e2${_scopeId}>${ssrInterpolate(listing.description)}</p><div class="flex items-center justify-between" data-v-a0c532e2${_scopeId}><div class="flex items-center gap-2" data-v-a0c532e2${_scopeId}><span class="text-yellow-400 font-bold" data-v-a0c532e2${_scopeId}>★ ${ssrInterpolate(listing.rating)}</span><span class="${ssrRenderClass([unref(isDarkMode) ? "text-gray-500" : "text-gray-600", "text-sm transition-colors duration-300"])}" data-v-a0c532e2${_scopeId}> (${ssrInterpolate(listing.reviews_count || listing.reviews)}) </span></div><button class="text-gray-400 hover:text-red-600 transition" data-v-a0c532e2${_scopeId}> ♥ </button></div></div>`);
            } else {
              return [
                createVNode("div", { class: "relative overflow-hidden h-48 bg-gray-200" }, [
                  createVNode("img", {
                    src: listing.image,
                    alt: listing.name || listing.title,
                    class: "w-full h-full object-cover group-hover:scale-110 transition duration-300",
                    loading: "lazy"
                  }, null, 8, ["src", "alt"]),
                  createVNode("div", { class: "absolute top-3 right-3 bg-gray-800 text-white px-3 py-1 rounded-full text-sm capitalize" }, toDisplayString(listing.category), 1)
                ]),
                createVNode("div", { class: "p-4" }, [
                  createVNode("h3", {
                    class: ["text-lg font-bold mb-2 line-clamp-2 transition-colors duration-300", unref(isDarkMode) ? "text-white" : "text-gray-900"]
                  }, toDisplayString(listing.name || listing.title), 3),
                  createVNode("p", {
                    class: ["text-sm mb-4 line-clamp-2 transition-colors duration-300", unref(isDarkMode) ? "text-gray-400" : "text-gray-600"]
                  }, toDisplayString(listing.description), 3),
                  createVNode("div", { class: "flex items-center justify-between" }, [
                    createVNode("div", { class: "flex items-center gap-2" }, [
                      createVNode("span", { class: "text-yellow-400 font-bold" }, "★ " + toDisplayString(listing.rating), 1),
                      createVNode("span", {
                        class: ["text-sm transition-colors duration-300", unref(isDarkMode) ? "text-gray-500" : "text-gray-600"]
                      }, " (" + toDisplayString(listing.reviews_count || listing.reviews) + ") ", 3)
                    ]),
                    createVNode("button", { class: "text-gray-400 hover:text-red-600 transition" }, " ♥ ")
                  ])
                ])
              ];
            }
          }),
          _: 2
        }, _parent));
      });
      _push(`<!--]--></div></div></section>`);
    };
  }
});
const _sfc_setup$6 = _sfc_main$6.setup;
_sfc_main$6.setup = (props, ctx) => {
  const ssrContext = useSSRContext();
  (ssrContext.modules || (ssrContext.modules = /* @__PURE__ */ new Set())).add("resources/js/Components/ListingCard.vue");
  return _sfc_setup$6 ? _sfc_setup$6(props, ctx) : void 0;
};
const ListingCard = /* @__PURE__ */ _export_sfc(_sfc_main$6, [["__scopeId", "data-v-a0c532e2"]]);
const _sfc_main$5 = /* @__PURE__ */ defineComponent({
  __name: "CityCard",
  __ssrInlineRender: true,
  props: {
    cities: {}
  },
  setup(__props) {
    const isDarkMode = inject("isDarkMode", computed(() => false));
    return (_ctx, _push, _parent, _attrs) => {
      _push(`<section${ssrRenderAttrs(mergeProps({
        class: ["py-16 transition-colors duration-300", unref(isDarkMode) ? "bg-gray-900" : "bg-gray-50"]
      }, _attrs))}><div class="max-w-7xl mx-auto px-4"><div class="text-center mb-12"><h2 class="text-3xl md:text-4xl font-bold text-gray-900 mb-2"> Explore Listings By <span class="text-red-600">Cities</span></h2><p class="text-gray-600 text-lg"> Our cities have the most popular &amp; recent listings </p></div><div class="grid grid-cols-1 md:grid-cols-2 lg:grid-cols-3 gap-6"><!--[-->`);
      ssrRenderList(__props.cities, (city) => {
        _push(`<div class="group relative overflow-hidden rounded-lg shadow-lg hover:shadow-2xl transition duration-300 h-64 cursor-pointer"><img${ssrRenderAttr("src", city.image)}${ssrRenderAttr("alt", city.name)} class="absolute inset-0 w-full h-full object-cover group-hover:scale-110 transition duration-300" loading="lazy"><div class="absolute inset-0 bg-black/40 group-hover:bg-black/60 transition duration-300"></div><div class="absolute inset-0 flex flex-col justify-end p-6 text-white"><h3 class="text-2xl font-bold mb-2">${ssrInterpolate(city.name)}</h3><p class="text-gray-100 text-sm mb-4">${ssrInterpolate(city.description)}</p><div class="hidden group-hover:flex gap-2 flex-wrap"><!--[-->`);
        ssrRenderList(city.highlights, (highlight) => {
          _push(`<span class="bg-red-600 text-white px-3 py-1 rounded-full text-xs font-semibold">${ssrInterpolate(highlight)}</span>`);
        });
        _push(`<!--]--></div></div></div>`);
      });
      _push(`<!--]--></div></div></section>`);
    };
  }
});
const _sfc_setup$5 = _sfc_main$5.setup;
_sfc_main$5.setup = (props, ctx) => {
  const ssrContext = useSSRContext();
  (ssrContext.modules || (ssrContext.modules = /* @__PURE__ */ new Set())).add("resources/js/Components/CityCard.vue");
  return _sfc_setup$5 ? _sfc_setup$5(props, ctx) : void 0;
};
const _sfc_main$4 = /* @__PURE__ */ defineComponent({
  __name: "TestimonialCard",
  __ssrInlineRender: true,
  props: {
    testimonials: {}
  },
  setup(__props) {
    const isDarkMode = inject("isDarkMode", computed(() => false));
    return (_ctx, _push, _parent, _attrs) => {
      _push(`<section${ssrRenderAttrs(mergeProps({
        class: ["py-16 transition-colors duration-300", unref(isDarkMode) ? "bg-gray-900" : "bg-white"]
      }, _attrs))} data-v-a02794aa><div class="max-w-7xl mx-auto px-4" data-v-a02794aa><div class="text-center mb-12" data-v-a02794aa><h2 class="text-3xl md:text-4xl font-bold text-gray-900 mb-2" data-v-a02794aa> Our Great <span class="text-red-600" data-v-a02794aa>Reviews</span></h2><p class="text-gray-600 text-lg" data-v-a02794aa> Our clients love our service and give positive reviews </p></div><div class="grid grid-cols-1 md:grid-cols-2 lg:grid-cols-4 gap-6" data-v-a02794aa><!--[-->`);
      ssrRenderList(__props.testimonials, (testimonial) => {
        _push(`<div class="bg-white rounded-lg p-6 shadow-md hover:shadow-lg transition duration-300" data-v-a02794aa><div class="flex gap-1 mb-4" data-v-a02794aa><!--[-->`);
        ssrRenderList(5, (n) => {
          _push(`<span class="text-yellow-400 text-lg" data-v-a02794aa> ★ </span>`);
        });
        _push(`<!--]--></div><p class="text-gray-700 mb-6 line-clamp-4" data-v-a02794aa>${ssrInterpolate(testimonial.content)}</p><div class="flex items-center gap-4" data-v-a02794aa><img${ssrRenderAttr("src", testimonial.image)}${ssrRenderAttr("alt", testimonial.name)} class="w-12 h-12 rounded-full object-cover" loading="lazy" data-v-a02794aa><div data-v-a02794aa><p class="font-bold text-gray-900" data-v-a02794aa>${ssrInterpolate(testimonial.name)}</p><p class="text-sm text-gray-600" data-v-a02794aa>${ssrInterpolate(testimonial.role)}</p></div></div></div>`);
      });
      _push(`<!--]--></div></div></section>`);
    };
  }
});
const _sfc_setup$4 = _sfc_main$4.setup;
_sfc_main$4.setup = (props, ctx) => {
  const ssrContext = useSSRContext();
  (ssrContext.modules || (ssrContext.modules = /* @__PURE__ */ new Set())).add("resources/js/Components/TestimonialCard.vue");
  return _sfc_setup$4 ? _sfc_setup$4(props, ctx) : void 0;
};
const TestimonialCard = /* @__PURE__ */ _export_sfc(_sfc_main$4, [["__scopeId", "data-v-a02794aa"]]);
const _sfc_main$3 = /* @__PURE__ */ defineComponent({
  __name: "NewsCard",
  __ssrInlineRender: true,
  props: {
    news: {}
  },
  setup(__props) {
    inject("isDarkMode", computed(() => false));
    const formatDate = (dateString) => {
      const date = new Date(dateString);
      return date.toLocaleDateString("en-US", {
        month: "short",
        day: "numeric",
        year: "numeric"
      });
    };
    return (_ctx, _push, _parent, _attrs) => {
      _push(`<section${ssrRenderAttrs(mergeProps({ class: "py-16 bg-white" }, _attrs))} data-v-156baf7c><div class="max-w-7xl mx-auto px-4" data-v-156baf7c><div class="text-center mb-12" data-v-156baf7c><h2 class="text-3xl md:text-4xl font-bold text-gray-900 mb-2" data-v-156baf7c> Latest Updates <span class="text-red-600" data-v-156baf7c>News</span></h2><p class="text-gray-600 text-lg" data-v-156baf7c> Just arrived and get latest &amp; trending updates about listing </p></div><div class="grid grid-cols-1 md:grid-cols-3 gap-6" data-v-156baf7c><!--[-->`);
      ssrRenderList(__props.news, (item) => {
        _push(`<div class="bg-white rounded-lg overflow-hidden shadow-md hover:shadow-lg transition duration-300" data-v-156baf7c><div class="relative overflow-hidden h-48 bg-gray-200" data-v-156baf7c><img${ssrRenderAttr("src", item.image)}${ssrRenderAttr("alt", item.title)} class="w-full h-full object-cover hover:scale-110 transition duration-300" loading="lazy" data-v-156baf7c></div><div class="p-6" data-v-156baf7c><div class="flex items-center gap-2 mb-3" data-v-156baf7c><span class="text-red-600 text-sm font-semibold uppercase" data-v-156baf7c>${ssrInterpolate(item.category)}</span><span class="text-gray-500 text-sm" data-v-156baf7c>${ssrInterpolate(formatDate(item.date))}</span></div><h3 class="text-lg font-bold text-gray-900 mb-3 line-clamp-2" data-v-156baf7c>${ssrInterpolate(item.title)}</h3><p class="text-gray-600 text-sm mb-4 line-clamp-3" data-v-156baf7c>${ssrInterpolate(item.excerpt)}</p><button class="text-red-600 font-semibold hover:text-red-700 transition flex items-center gap-2" data-v-156baf7c> Read More <span data-v-156baf7c>→</span></button></div></div>`);
      });
      _push(`<!--]--></div></div></section>`);
    };
  }
});
const _sfc_setup$3 = _sfc_main$3.setup;
_sfc_main$3.setup = (props, ctx) => {
  const ssrContext = useSSRContext();
  (ssrContext.modules || (ssrContext.modules = /* @__PURE__ */ new Set())).add("resources/js/Components/NewsCard.vue");
  return _sfc_setup$3 ? _sfc_setup$3(props, ctx) : void 0;
};
const NewsCard = /* @__PURE__ */ _export_sfc(_sfc_main$3, [["__scopeId", "data-v-156baf7c"]]);
const _sfc_main$2 = /* @__PURE__ */ defineComponent({
  __name: "EventCard",
  __ssrInlineRender: true,
  props: {
    events: {}
  },
  setup(__props) {
    const isDarkMode = inject("isDarkMode", computed(() => false));
    const formatDate = (dateString) => {
      const date = /* @__PURE__ */ new Date(dateString + "T00:00:00");
      return date.toLocaleDateString("en-US", {
        month: "short",
        day: "numeric",
        year: "numeric"
      });
    };
    const getEventName = (event) => {
      return event.name || event.title || "Event";
    };
    return (_ctx, _push, _parent, _attrs) => {
      _push(`<section${ssrRenderAttrs(mergeProps({
        class: ["py-16 transition-colors duration-300", unref(isDarkMode) ? "bg-gray-900" : "bg-white"]
      }, _attrs))} data-v-21660b65><div class="max-w-7xl mx-auto px-4" data-v-21660b65><div class="text-center mb-12" data-v-21660b65><h2 class="${ssrRenderClass([unref(isDarkMode) ? "text-white" : "text-gray-900", "text-3xl md:text-4xl font-bold mb-2 transition-colors duration-300"])}" data-v-21660b65> Explore Upcoming <span class="text-red-600" data-v-21660b65>Events</span></h2><p class="${ssrRenderClass([unref(isDarkMode) ? "text-gray-400" : "text-gray-600", "text-lg transition-colors duration-300"])}" data-v-21660b65> Browse our upcoming events and add your own </p></div><div class="grid grid-cols-1 md:grid-cols-2 lg:grid-cols-3 gap-6" data-v-21660b65><!--[-->`);
      ssrRenderList(__props.events, (event) => {
        _push(ssrRenderComponent(unref(Link), {
          key: event.id,
          href: `/events/${event.slug}`,
          class: ["rounded-lg overflow-hidden shadow-md hover:shadow-xl transition duration-300", unref(isDarkMode) ? "bg-gray-800" : "bg-white"]
        }, {
          default: withCtx((_, _push2, _parent2, _scopeId) => {
            if (_push2) {
              _push2(`<div class="relative overflow-hidden h-48 bg-gray-200" data-v-21660b65${_scopeId}><img${ssrRenderAttr("src", event.image)}${ssrRenderAttr("alt", getEventName(event))} class="w-full h-full object-cover hover:scale-110 transition duration-300" loading="lazy" data-v-21660b65${_scopeId}><div class="absolute top-3 left-3 bg-red-600 text-white px-4 py-2 rounded-lg font-bold text-center" data-v-21660b65${_scopeId}><div class="text-xs uppercase" data-v-21660b65${_scopeId}>${ssrInterpolate(formatDate(event.date).split(" ")[0])}</div><div class="text-lg" data-v-21660b65${_scopeId}>${ssrInterpolate(formatDate(event.date).split(" ")[1])}</div></div></div><div class="p-4" data-v-21660b65${_scopeId}><h3 class="${ssrRenderClass([unref(isDarkMode) ? "text-white" : "text-gray-900", "text-lg font-bold mb-2 line-clamp-2 transition-colors duration-300"])}" data-v-21660b65${_scopeId}>${ssrInterpolate(getEventName(event))}</h3><p class="${ssrRenderClass([unref(isDarkMode) ? "text-gray-400" : "text-gray-600", "text-sm line-clamp-2 transition-colors duration-300 mb-3"])}" data-v-21660b65${_scopeId}>${ssrInterpolate(event.description)}</p>`);
              if (event.price || event.rating) {
                _push2(`<div class="flex items-center justify-between text-sm" data-v-21660b65${_scopeId}>`);
                if (event.price) {
                  _push2(`<span class="font-semibold text-red-600" data-v-21660b65${_scopeId}>${ssrInterpolate(event.price)}</span>`);
                } else {
                  _push2(`<!---->`);
                }
                if (event.rating) {
                  _push2(`<span class="text-yellow-400" data-v-21660b65${_scopeId}>★ ${ssrInterpolate(event.rating)}</span>`);
                } else {
                  _push2(`<!---->`);
                }
                _push2(`</div>`);
              } else {
                _push2(`<!---->`);
              }
              _push2(`</div>`);
            } else {
              return [
                createVNode("div", { class: "relative overflow-hidden h-48 bg-gray-200" }, [
                  createVNode("img", {
                    src: event.image,
                    alt: getEventName(event),
                    class: "w-full h-full object-cover hover:scale-110 transition duration-300",
                    loading: "lazy"
                  }, null, 8, ["src", "alt"]),
                  createVNode("div", { class: "absolute top-3 left-3 bg-red-600 text-white px-4 py-2 rounded-lg font-bold text-center" }, [
                    createVNode("div", { class: "text-xs uppercase" }, toDisplayString(formatDate(event.date).split(" ")[0]), 1),
                    createVNode("div", { class: "text-lg" }, toDisplayString(formatDate(event.date).split(" ")[1]), 1)
                  ])
                ]),
                createVNode("div", { class: "p-4" }, [
                  createVNode("h3", {
                    class: ["text-lg font-bold mb-2 line-clamp-2 transition-colors duration-300", unref(isDarkMode) ? "text-white" : "text-gray-900"]
                  }, toDisplayString(getEventName(event)), 3),
                  createVNode("p", {
                    class: ["text-sm line-clamp-2 transition-colors duration-300 mb-3", unref(isDarkMode) ? "text-gray-400" : "text-gray-600"]
                  }, toDisplayString(event.description), 3),
                  event.price || event.rating ? (openBlock(), createBlock("div", {
                    key: 0,
                    class: "flex items-center justify-between text-sm"
                  }, [
                    event.price ? (openBlock(), createBlock("span", {
                      key: 0,
                      class: "font-semibold text-red-600"
                    }, toDisplayString(event.price), 1)) : createCommentVNode("", true),
                    event.rating ? (openBlock(), createBlock("span", {
                      key: 1,
                      class: "text-yellow-400"
                    }, "★ " + toDisplayString(event.rating), 1)) : createCommentVNode("", true)
                  ])) : createCommentVNode("", true)
                ])
              ];
            }
          }),
          _: 2
        }, _parent));
      });
      _push(`<!--]--></div></div></section>`);
    };
  }
});
const _sfc_setup$2 = _sfc_main$2.setup;
_sfc_main$2.setup = (props, ctx) => {
  const ssrContext = useSSRContext();
  (ssrContext.modules || (ssrContext.modules = /* @__PURE__ */ new Set())).add("resources/js/Components/EventCard.vue");
  return _sfc_setup$2 ? _sfc_setup$2(props, ctx) : void 0;
};
const EventCard = /* @__PURE__ */ _export_sfc(_sfc_main$2, [["__scopeId", "data-v-21660b65"]]);
const _sfc_main$1 = /* @__PURE__ */ defineComponent({
  __name: "NewsletterBox",
  __ssrInlineRender: true,
  props: {
    title: {},
    subtitle: {}
  },
  setup(__props) {
    const email = ref("");
    inject("isDarkMode", computed(() => false));
    return (_ctx, _push, _parent, _attrs) => {
      _push(`<section${ssrRenderAttrs(mergeProps({ class: "py-16 bg-red-600" }, _attrs))}><div class="max-w-4xl mx-auto px-4 text-center"><h2 class="text-3xl md:text-4xl font-bold text-white mb-2">${ssrInterpolate(__props.title || "Subscribe Our Newsletter!")}</h2><p class="text-red-100 text-lg mb-8">${ssrInterpolate(__props.subtitle || "Get updated with latest deals and news update in your email.")}</p><form class="flex flex-col md:flex-row gap-4 max-w-md mx-auto"><input${ssrRenderAttr("value", email.value)} type="email" placeholder="Enter your email" class="flex-1 px-4 py-3 rounded-lg focus:outline-none focus:ring-2 focus:ring-white" required><button type="submit" class="bg-white text-red-600 font-semibold px-8 py-3 rounded-lg hover:bg-gray-100 transition duration-300 whitespace-nowrap"> Subscribe </button></form></div></section>`);
    };
  }
});
const _sfc_setup$1 = _sfc_main$1.setup;
_sfc_main$1.setup = (props, ctx) => {
  const ssrContext = useSSRContext();
  (ssrContext.modules || (ssrContext.modules = /* @__PURE__ */ new Set())).add("resources/js/Components/NewsletterBox.vue");
  return _sfc_setup$1 ? _sfc_setup$1(props, ctx) : void 0;
};
const _sfc_main = /* @__PURE__ */ defineComponent({
  __name: "Home",
  __ssrInlineRender: true,
  props: {
    meta: {},
    heroSlides: {},
    categories: {},
    featuredAttractions: {},
    popularAttractions: {},
    cities: {},
    testimonials: {},
    news: {},
    upcomingEvents: {}
  },
  setup(__props) {
    inject("isDarkMode", computed(() => false));
    return (_ctx, _push, _parent, _attrs) => {
      _push(`<!--[-->`);
      _push(ssrRenderComponent(unref(Head), null, {
        default: withCtx((_, _push2, _parent2, _scopeId) => {
          if (_push2) {
            _push2(`<title${_scopeId}>${ssrInterpolate(__props.meta.title)}</title><meta name="description"${ssrRenderAttr("content", __props.meta.description)}${_scopeId}><meta property="og:title"${ssrRenderAttr("content", __props.meta.title)}${_scopeId}><meta property="og:description"${ssrRenderAttr("content", __props.meta.description)}${_scopeId}><meta property="og:type" content="website"${_scopeId}>`);
          } else {
            return [
              createVNode("title", null, toDisplayString(__props.meta.title), 1),
              createVNode("meta", {
                name: "description",
                content: __props.meta.description
              }, null, 8, ["content"]),
              createVNode("meta", {
                property: "og:title",
                content: __props.meta.title
              }, null, 8, ["content"]),
              createVNode("meta", {
                property: "og:description",
                content: __props.meta.description
              }, null, 8, ["content"]),
              createVNode("meta", {
                property: "og:type",
                content: "website"
              })
            ];
          }
        }),
        _: 1
      }, _parent));
      _push(`<main>`);
      _push(ssrRenderComponent(HeroSlider, {
        slides: __props.heroSlides,
        "auto-play-interval": 5e3
      }, null, _parent));
      _push(ssrRenderComponent(CategoryGrid, { categories: __props.categories }, null, _parent));
      _push(ssrRenderComponent(ListingCard, {
        title: "Popular Listings in Greene County",
        subtitle: "Explore top & popular business listings",
        listings: __props.featuredAttractions
      }, null, _parent));
      _push(ssrRenderComponent(_sfc_main$5, { cities: __props.cities }, null, _parent));
      _push(ssrRenderComponent(TestimonialCard, { testimonials: __props.testimonials }, null, _parent));
      _push(ssrRenderComponent(NewsCard, { news: __props.news }, null, _parent));
      _push(ssrRenderComponent(EventCard, {
        title: "Explore Upcoming",
        events: __props.upcomingEvents
      }, null, _parent));
      _push(ssrRenderComponent(_sfc_main$1, {
        title: "Subscribe Our Newsletter!",
        subtitle: "Get updated with latest deals and news update in your email."
      }, null, _parent));
      _push(`</main><!--]-->`);
    };
  }
});
const _sfc_setup = _sfc_main.setup;
_sfc_main.setup = (props, ctx) => {
  const ssrContext = useSSRContext();
  (ssrContext.modules || (ssrContext.modules = /* @__PURE__ */ new Set())).add("resources/js/Pages/Landing/Home.vue");
  return _sfc_setup ? _sfc_setup(props, ctx) : void 0;
};
export {
  _sfc_main as default
};
