import { defineComponent, inject, computed, unref, withCtx, createVNode, toDisplayString, useSSRContext } from "vue";
import { ssrRenderComponent, ssrInterpolate, ssrRenderAttr, ssrRenderClass } from "vue/server-renderer";
import { Head } from "@inertiajs/vue3";
const _sfc_main = /* @__PURE__ */ defineComponent({
  __name: "Events",
  __ssrInlineRender: true,
  props: {
    meta: {}
  },
  setup(__props) {
    const isDarkMode = inject("isDarkMode", computed(() => false));
    return (_ctx, _push, _parent, _attrs) => {
      _push(`<!--[-->`);
      _push(ssrRenderComponent(unref(Head), null, {
        default: withCtx((_, _push2, _parent2, _scopeId) => {
          if (_push2) {
            _push2(`<title${_scopeId}>${ssrInterpolate(__props.meta.title)}</title><meta name="description"${ssrRenderAttr("content", __props.meta.description)}${_scopeId}>`);
          } else {
            return [
              createVNode("title", null, toDisplayString(__props.meta.title), 1),
              createVNode("meta", {
                name: "description",
                content: __props.meta.description
              }, null, 8, ["content"])
            ];
          }
        }),
        _: 1
      }, _parent));
      _push(`<main class="${ssrRenderClass([unref(isDarkMode) ? "bg-gray-900" : "bg-white", "transition-colors duration-300"])}"><section class="max-w-7xl mx-auto px-4 py-20"><h1 class="${ssrRenderClass([unref(isDarkMode) ? "text-white" : "text-gray-900", "text-4xl font-bold mb-4 transition-colors duration-300"])}">Events</h1><p class="${ssrRenderClass([unref(isDarkMode) ? "text-gray-400" : "text-gray-600", "text-lg transition-colors duration-300"])}">Browse upcoming events in Greene County.</p></section></main><!--]-->`);
    };
  }
});
const _sfc_setup = _sfc_main.setup;
_sfc_main.setup = (props, ctx) => {
  const ssrContext = useSSRContext();
  (ssrContext.modules || (ssrContext.modules = /* @__PURE__ */ new Set())).add("resources/js/Pages/Landing/Events.vue");
  return _sfc_setup ? _sfc_setup(props, ctx) : void 0;
};
export {
  _sfc_main as default
};
