import { defineComponent, inject, computed, unref, withCtx, createVNode, toDisplayString, createTextVNode, useSSRContext } from "vue";
import { ssrRenderComponent, ssrInterpolate, ssrRenderAttr, ssrRenderClass, ssrRenderList } from "vue/server-renderer";
import { Head, Link } from "@inertiajs/vue3";
import { G as GallerySlider } from "./GallerySlider-BDj3OZAy.js";
import "./_plugin-vue_export-helper-1tPrXgE0.js";
const _sfc_main = /* @__PURE__ */ defineComponent({
  __name: "AttractionDetail",
  __ssrInlineRender: true,
  props: {
    meta: {},
    attraction: {}
  },
  setup(__props) {
    const isDarkMode = inject("isDarkMode", computed(() => false));
    const formatRating = (rating) => {
      return "★".repeat(Math.floor(rating)) + "☆".repeat(5 - Math.floor(rating));
    };
    return (_ctx, _push, _parent, _attrs) => {
      _push(`<!--[-->`);
      _push(ssrRenderComponent(unref(Head), null, {
        default: withCtx((_, _push2, _parent2, _scopeId) => {
          if (_push2) {
            _push2(`<title${_scopeId}>${ssrInterpolate(__props.meta.title)}</title><meta name="description"${ssrRenderAttr("content", __props.meta.description)}${_scopeId}><meta property="og:title"${ssrRenderAttr("content", __props.meta.title)}${_scopeId}><meta property="og:description"${ssrRenderAttr("content", __props.meta.description)}${_scopeId}><meta property="og:type" content="website"${_scopeId}><meta property="og:image"${ssrRenderAttr("content", __props.attraction.image)}${_scopeId}>`);
          } else {
            return [
              createVNode("title", null, toDisplayString(__props.meta.title), 1),
              createVNode("meta", {
                name: "description",
                content: __props.meta.description
              }, null, 8, ["content"]),
              createVNode("meta", {
                property: "og:title",
                content: __props.meta.title
              }, null, 8, ["content"]),
              createVNode("meta", {
                property: "og:description",
                content: __props.meta.description
              }, null, 8, ["content"]),
              createVNode("meta", {
                property: "og:type",
                content: "website"
              }),
              createVNode("meta", {
                property: "og:image",
                content: __props.attraction.image
              }, null, 8, ["content"])
            ];
          }
        }),
        _: 1
      }, _parent));
      _push(`<main class="${ssrRenderClass([unref(isDarkMode) ? "bg-gray-900" : "bg-gray-50", "transition-colors duration-300"])}"><div class="relative h-[400px] md:h-[500px]"><img${ssrRenderAttr("src", __props.attraction.image)}${ssrRenderAttr("alt", __props.attraction.name)} class="w-full h-full object-cover"><div class="absolute inset-0 bg-gradient-to-t from-black/70 via-black/30 to-transparent"></div><div class="absolute bottom-0 left-0 right-0 pb-8"><div class="max-w-7xl mx-auto px-4"><div class="flex items-center gap-2 mb-4">`);
      _push(ssrRenderComponent(unref(Link), {
        href: "/attractions",
        class: "text-white/80 hover:text-white text-sm"
      }, {
        default: withCtx((_, _push2, _parent2, _scopeId) => {
          if (_push2) {
            _push2(`Attractions`);
          } else {
            return [
              createTextVNode("Attractions")
            ];
          }
        }),
        _: 1
      }, _parent));
      _push(`<span class="text-white/60">/</span><span class="text-white text-sm">${ssrInterpolate(__props.attraction.name)}</span></div><h1 class="text-4xl md:text-5xl font-bold text-white mb-3">${ssrInterpolate(__props.attraction.name)}</h1><div class="flex items-center gap-4 text-white"><span class="text-yellow-400 text-xl">${ssrInterpolate(formatRating(__props.attraction.rating))}</span><span class="text-sm">${ssrInterpolate(__props.attraction.rating)} (${ssrInterpolate(__props.attraction.reviews_count)} reviews)</span><span class="px-3 py-1 bg-red-600 rounded-full text-sm font-medium">${ssrInterpolate(__props.attraction.category)}</span></div></div></div></div><div class="max-w-7xl mx-auto px-4 py-12"><div class="grid grid-cols-1 lg:grid-cols-3 gap-8"><div class="lg:col-span-2 space-y-8"><div class="${ssrRenderClass([unref(isDarkMode) ? "bg-gray-800" : "bg-white", "rounded-2xl shadow-lg p-6 transition-colors duration-300"])}"><h2 class="${ssrRenderClass([unref(isDarkMode) ? "text-white" : "text-gray-900", "text-2xl font-bold mb-4 transition-colors duration-300"])}"> About This Attraction </h2><p class="${ssrRenderClass([unref(isDarkMode) ? "text-gray-300" : "text-gray-700", "text-lg leading-relaxed transition-colors duration-300"])}">${ssrInterpolate(__props.attraction.long_description)}</p></div>`);
      if (__props.attraction.features.length > 0) {
        _push(`<div class="${ssrRenderClass([unref(isDarkMode) ? "bg-gray-800" : "bg-white", "rounded-2xl shadow-lg p-6 transition-colors duration-300"])}"><h2 class="${ssrRenderClass([unref(isDarkMode) ? "text-white" : "text-gray-900", "text-2xl font-bold mb-4 transition-colors duration-300"])}"> Features &amp; Amenities </h2><div class="grid grid-cols-2 md:grid-cols-3 gap-4"><!--[-->`);
        ssrRenderList(__props.attraction.features, (feature) => {
          _push(`<div class="${ssrRenderClass([unref(isDarkMode) ? "text-gray-300" : "text-gray-700", "flex items-center gap-2 transition-colors duration-300"])}"><svg class="w-5 h-5 text-red-600" fill="currentColor" viewBox="0 0 20 20"><path fill-rule="evenodd" d="M16.707 5.293a1 1 0 010 1.414l-8 8a1 1 0 01-1.414 0l-4-4a1 1 0 011.414-1.414L8 12.586l7.293-7.293a1 1 0 011.414 0z" clip-rule="evenodd"></path></svg><span>${ssrInterpolate(feature)}</span></div>`);
        });
        _push(`<!--]--></div></div>`);
      } else {
        _push(`<!---->`);
      }
      if (__props.attraction.gallery.length > 0) {
        _push(`<div>`);
        _push(ssrRenderComponent(GallerySlider, {
          images: __props.attraction.gallery,
          title: `${__props.attraction.name} - Photo Gallery`,
          altPrefix: __props.attraction.name
        }, null, _parent));
        _push(`</div>`);
      } else {
        _push(`<!---->`);
      }
      _push(`</div><div class="space-y-6"><div class="${ssrRenderClass([unref(isDarkMode) ? "bg-gray-800" : "bg-white", "rounded-2xl shadow-lg p-6 transition-colors duration-300"])}"><h3 class="${ssrRenderClass([unref(isDarkMode) ? "text-white" : "text-gray-900", "text-xl font-bold mb-4 transition-colors duration-300"])}"> Contact Information </h3><div class="space-y-3"><div class="flex items-start gap-3"><svg class="w-5 h-5 text-red-600 mt-1 flex-shrink-0" fill="none" stroke="currentColor" viewBox="0 0 24 24"><path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M17.657 16.657L13.414 20.9a1.998 1.998 0 01-2.827 0l-4.244-4.243a8 8 0 1111.314 0z"></path><path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M15 11a3 3 0 11-6 0 3 3 0 016 0z"></path></svg><div><p class="${ssrRenderClass([unref(isDarkMode) ? "text-gray-300" : "text-gray-700", "font-medium transition-colors duration-300"])}">${ssrInterpolate(__props.attraction.address)}</p><p class="${ssrRenderClass([unref(isDarkMode) ? "text-gray-400" : "text-gray-500", "text-sm transition-colors duration-300"])}">${ssrInterpolate(__props.attraction.city)}, VA </p></div></div>`);
      if (__props.attraction.phone) {
        _push(`<div class="flex items-center gap-3"><svg class="w-5 h-5 text-red-600 flex-shrink-0" fill="none" stroke="currentColor" viewBox="0 0 24 24"><path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M3 5a2 2 0 012-2h3.28a1 1 0 01.948.684l1.498 4.493a1 1 0 01-.502 1.21l-2.257 1.13a11.042 11.042 0 005.516 5.516l1.13-2.257a1 1 0 011.21-.502l4.493 1.498a1 1 0 01.684.949V19a2 2 0 01-2 2h-1C9.716 21 3 14.284 3 6V5z"></path></svg><a${ssrRenderAttr("href", `tel:${__props.attraction.phone}`)} class="${ssrRenderClass([unref(isDarkMode) ? "text-gray-300" : "text-gray-700", "font-medium hover:text-red-600 transition-colors duration-300"])}">${ssrInterpolate(__props.attraction.phone)}</a></div>`);
      } else {
        _push(`<!---->`);
      }
      if (__props.attraction.email) {
        _push(`<div class="flex items-center gap-3"><svg class="w-5 h-5 text-red-600 flex-shrink-0" fill="none" stroke="currentColor" viewBox="0 0 24 24"><path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M3 8l7.89 5.26a2 2 0 002.22 0L21 8M5 19h14a2 2 0 002-2V7a2 2 0 00-2-2H5a2 2 0 00-2 2v10a2 2 0 002 2z"></path></svg><a${ssrRenderAttr("href", `mailto:${__props.attraction.email}`)} class="${ssrRenderClass([unref(isDarkMode) ? "text-gray-300" : "text-gray-700", "font-medium hover:text-red-600 transition-colors duration-300"])}">${ssrInterpolate(__props.attraction.email)}</a></div>`);
      } else {
        _push(`<!---->`);
      }
      if (__props.attraction.website) {
        _push(`<div class="flex items-center gap-3"><svg class="w-5 h-5 text-red-600 flex-shrink-0" fill="none" stroke="currentColor" viewBox="0 0 24 24"><path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M21 12a9 9 0 01-9 9m9-9a9 9 0 00-9-9m9 9H3m9 9a9 9 0 01-9-9m9 9c1.657 0 3-4.03 3-9s-1.343-9-3-9m0 18c-1.657 0-3-4.03-3-9s1.343-9 3-9m-9 9a9 9 0 019-9"></path></svg><a${ssrRenderAttr("href", __props.attraction.website)} target="_blank" rel="noopener noreferrer" class="${ssrRenderClass([unref(isDarkMode) ? "text-gray-300" : "text-gray-700", "font-medium hover:text-red-600 transition-colors duration-300"])}"> Visit Website </a></div>`);
      } else {
        _push(`<!---->`);
      }
      _push(`</div></div>`);
      if (__props.attraction.hours) {
        _push(`<div class="${ssrRenderClass([unref(isDarkMode) ? "bg-gray-800" : "bg-white", "rounded-2xl shadow-lg p-6 transition-colors duration-300"])}"><h3 class="${ssrRenderClass([unref(isDarkMode) ? "text-white" : "text-gray-900", "text-xl font-bold mb-4 transition-colors duration-300"])}"> Hours of Operation </h3><p class="${ssrRenderClass([unref(isDarkMode) ? "text-gray-300" : "text-gray-700", "transition-colors duration-300"])}">${ssrInterpolate(__props.attraction.hours)}</p></div>`);
      } else {
        _push(`<!---->`);
      }
      _push(`<a${ssrRenderAttr("href", `https://www.google.com/maps/search/?api=1&query=${encodeURIComponent(__props.attraction.address + ", " + __props.attraction.city + ", VA")}`)} target="_blank" rel="noopener noreferrer" class="block w-full bg-red-600 hover:bg-red-700 text-white text-center font-semibold py-3 px-6 rounded-lg transition-all duration-300 transform hover:scale-105"> Get Directions </a></div></div>`);
      if (__props.attraction.nearby_attractions.length > 0) {
        _push(`<div class="mt-12"><h2 class="${ssrRenderClass([unref(isDarkMode) ? "text-white" : "text-gray-900", "text-3xl font-bold mb-6 transition-colors duration-300"])}"> Nearby Attractions </h2><div class="grid grid-cols-1 md:grid-cols-3 gap-6"><!--[-->`);
        ssrRenderList(__props.attraction.nearby_attractions, (nearby) => {
          _push(ssrRenderComponent(unref(Link), {
            key: nearby.id,
            href: `/attractions/${nearby.slug}`,
            class: ["group rounded-2xl shadow-lg overflow-hidden transition-all duration-300 transform hover:scale-105", unref(isDarkMode) ? "bg-gray-800" : "bg-white"]
          }, {
            default: withCtx((_, _push2, _parent2, _scopeId) => {
              if (_push2) {
                _push2(`<img${ssrRenderAttr("src", nearby.image)}${ssrRenderAttr("alt", nearby.name)} class="w-full h-48 object-cover"${_scopeId}><div class="p-4"${_scopeId}><h3 class="${ssrRenderClass([unref(isDarkMode) ? "text-white" : "text-gray-900", "font-bold text-lg mb-2 group-hover:text-red-600 transition-colors duration-300"])}"${_scopeId}>${ssrInterpolate(nearby.name)}</h3><p class="${ssrRenderClass([unref(isDarkMode) ? "text-gray-400" : "text-gray-600", "text-sm transition-colors duration-300"])}"${_scopeId}>${ssrInterpolate(nearby.description)}</p></div>`);
              } else {
                return [
                  createVNode("img", {
                    src: nearby.image,
                    alt: nearby.name,
                    class: "w-full h-48 object-cover"
                  }, null, 8, ["src", "alt"]),
                  createVNode("div", { class: "p-4" }, [
                    createVNode("h3", {
                      class: ["font-bold text-lg mb-2 group-hover:text-red-600 transition-colors duration-300", unref(isDarkMode) ? "text-white" : "text-gray-900"]
                    }, toDisplayString(nearby.name), 3),
                    createVNode("p", {
                      class: ["text-sm transition-colors duration-300", unref(isDarkMode) ? "text-gray-400" : "text-gray-600"]
                    }, toDisplayString(nearby.description), 3)
                  ])
                ];
              }
            }),
            _: 2
          }, _parent));
        });
        _push(`<!--]--></div></div>`);
      } else {
        _push(`<!---->`);
      }
      _push(`</div></main><!--]-->`);
    };
  }
});
const _sfc_setup = _sfc_main.setup;
_sfc_main.setup = (props, ctx) => {
  const ssrContext = useSSRContext();
  (ssrContext.modules || (ssrContext.modules = /* @__PURE__ */ new Set())).add("resources/js/Pages/Landing/AttractionDetail.vue");
  return _sfc_setup ? _sfc_setup(props, ctx) : void 0;
};
export {
  _sfc_main as default
};
