<?php

namespace App\Http\Controllers\Web\Landing;

use Inertia\Inertia;

class HomeController
{
    public function __invoke()
    {
        return Inertia::render('Landing/Home', [
            'meta' => [
                'title' => 'Explore Greene County | Visitor Center',
                'description' => 'Discover history, culture, dining, attractions, and natural beauty in Greene County, Virginia. Plan your visit to this charming mountain destination.',
            ],
            'heroSlides' => config('hero.hero_slides'),
            'categories' => config('content.categories'),
            'featuredAttractions' => config('attractions.featured'),
            'popularAttractions' => config('attractions.popular'),
            'cities' => config('cities.cities'),
            'testimonials' => config('content.testimonials'),
            'news' => config('content.news'),
            'upcomingEvents' => config('events.featured'),
        ]);
    }
}
