<?php

namespace App\Http\Controllers;

use Inertia\Inertia;

final class EventDetailController extends Controller
{
    public function __invoke(string $slug): \Inertia\Response
    {
        $events = config('events-detailed.events');
        $event = collect($events)->firstWhere('slug', $slug);

        if (!$event) {
            abort(404);
        }

        $nearbyEvents = collect($events)
            ->where('slug', '!=', $slug)
            ->where('city', $event['city'])
            ->take(3)
            ->values()
            ->toArray();

        return Inertia::render('Landing/EventDetail', [
            'meta' => [
                'title' => $event['name'] . ' | Explore Greene',
                'description' => $event['description'],
            ],
            'event' => $event,
            'nearbyEvents' => $nearbyEvents,
        ]);
    }
}
