<?php

namespace App\Http\Controllers;

use Inertia\Inertia;

class CategoriesController
{
    public function attractions()
    {
        $attractions = [
            ['id' => 1, 'name' => 'Shenandoah National Park', 'icon' => '🏔️', 'description' => 'Stunning mountain views and hiking trails', 'rating' => 4.8, 'location' => 'Stanardsville', 'image' => 'https://images.unsplash.com/photo-1506905925346-21bda4d32df4?w=500&h=400&fit=crop'],
            ['id' => 2, 'name' => 'Graves Mountain Lodge', 'icon' => '🏨', 'description' => 'Historic lodge with outdoor activities', 'rating' => 4.6, 'location' => 'Syria', 'image' => 'https://images.unsplash.com/photo-1511632765486-a01980e01a18?w=500&h=400&fit=crop'],
            ['id' => 3, 'name' => 'Early Mountain Vineyards', 'icon' => '🍷', 'description' => 'Award-winning winery with stunning views', 'rating' => 4.7, 'location' => 'Madison', 'image' => 'https://images.unsplash.com/photo-1510812431401-41d2cab2707d?w=500&h=400&fit=crop'],
            ['id' => 4, 'name' => 'Rapidan River Kayaking', 'icon' => '🚣', 'description' => 'Guided kayaking tours on beautiful river', 'rating' => 4.9, 'location' => 'Ruckersville', 'image' => 'https://images.unsplash.com/photo-1506905925346-21bda4d32df4?w=500&h=400&fit=crop'],
            ['id' => 5, 'name' => 'Greene County Historical Society', 'icon' => '📚', 'description' => 'Museum with local history and artifacts', 'rating' => 4.4, 'location' => 'Stanardsville', 'image' => 'https://images.unsplash.com/photo-1488459716781-6918f33427d1?w=500&h=400&fit=crop'],
            ['id' => 6, 'name' => 'Mountain View Orchards', 'icon' => '🍎', 'description' => 'Pick your own fruit and enjoy farm activities', 'rating' => 4.5, 'location' => 'Standardsville', 'image' => 'https://images.unsplash.com/photo-1441974231531-c6227db76b6e?w=500&h=400&fit=crop'],
        ];

        return Inertia::render('Categories/AttractionsCategory', [
            'attractions' => $attractions,
        ]);
    }

    public function dining()
    {
        $restaurants = [
            ['id' => 1, 'name' => 'Blue Ridge Cafe', 'icon' => '☕', 'description' => 'Cozy cafe with farm-to-table cuisine', 'rating' => 4.7, 'cuisine' => 'American', 'image' => 'https://images.unsplash.com/photo-1508737489454-3a3642f0fbb9?w=500&h=400&fit=crop'],
            ['id' => 2, 'name' => 'Mountain View Kitchen', 'icon' => '🍽️', 'description' => 'Fine dining with scenic views', 'rating' => 4.8, 'cuisine' => 'Contemporary', 'image' => 'https://images.unsplash.com/photo-1546069901-ba9599a7e63c?w=500&h=400&fit=crop'],
            ['id' => 3, 'name' => 'Heritage Restaurant', 'icon' => '🥘', 'description' => 'Traditional southern comfort food', 'rating' => 4.6, 'cuisine' => 'Southern', 'image' => 'https://images.unsplash.com/photo-1504674900967-77d150b21241?w=500&h=400&fit=crop'],
            ['id' => 4, 'name' => 'Vineyard Table', 'icon' => '🍇', 'description' => 'Wine-paired dining experience', 'rating' => 4.9, 'cuisine' => 'French', 'image' => 'https://images.unsplash.com/photo-1510812431401-41d2cab2707d?w=500&h=400&fit=crop'],
            ['id' => 5, 'name' => 'Riverside Bistro', 'icon' => '🌊', 'description' => 'Fresh seafood and river views', 'rating' => 4.5, 'cuisine' => 'Seafood', 'image' => 'https://images.unsplash.com/photo-1540189549336-e6e99c3679fe?w=500&h=400&fit=crop'],
            ['id' => 6, 'name' => 'Stone Hearth Pizzeria', 'icon' => '🍕', 'description' => 'Wood-fired pizza and Italian fare', 'rating' => 4.7, 'cuisine' => 'Italian', 'image' => 'https://images.unsplash.com/photo-1528840042246-b3200ce7b08b?w=500&h=400&fit=crop'],
        ];

        return Inertia::render('Categories/DiningCategory', [
            'restaurants' => $restaurants,
        ]);
    }

    public function events()
    {
        $events = [
            ['id' => 1, 'name' => 'Blue Ridge Mountain Festival', 'icon' => '🎉', 'description' => 'Annual celebration of music and culture', 'rating' => 4.8, 'date' => 'June 15-17', 'image' => 'https://images.unsplash.com/photo-1516399520891-468df5d13cb8?w=500&h=400&fit=crop'],
            ['id' => 2, 'name' => 'Wine & Food Pairing', 'icon' => '🍷', 'description' => 'Gourmet tasting experience', 'rating' => 4.9, 'date' => 'July 8-9', 'image' => 'https://images.unsplash.com/photo-1549737328-8b93e4d8888f?w=500&h=400&fit=crop'],
            ['id' => 3, 'name' => 'Summer Farmers Market', 'icon' => '🥕', 'description' => 'Local produce and crafts', 'rating' => 4.6, 'date' => 'June-September', 'image' => 'https://images.unsplash.com/photo-1488459716781-6918f33427d1?w=500&h=400&fit=crop'],
            ['id' => 4, 'name' => 'Moonlight Hiking Tour', 'icon' => '🌙', 'description' => 'Guided night hikes with naturalists', 'rating' => 4.7, 'date' => 'Monthly', 'image' => 'https://images.unsplash.com/photo-1511632765486-a01980e01a18?w=500&h=400&fit=crop'],
            ['id' => 5, 'name' => 'Art & Craft Fair', 'icon' => '🎨', 'description' => 'Local artists showcase their work', 'rating' => 4.5, 'date' => 'September 12-14', 'image' => 'https://images.unsplash.com/photo-1492684223066-81342ee5ff30?w=500&h=400&fit=crop'],
            ['id' => 6, 'name' => 'Harvest Festival', 'icon' => '🍂', 'description' => 'Fall celebration with music and food', 'rating' => 4.8, 'date' => 'October 20-22', 'image' => 'https://images.unsplash.com/photo-1519671482677-5b5ae8c1c9e8?w=500&h=400&fit=crop'],
        ];

        return Inertia::render('Categories/EventsCategory', [
            'events' => $events,
        ]);
    }

    public function nature()
    {
        $trails = [
            ['id' => 1, 'name' => 'Doris Nature Trail', 'icon' => '🥾', 'description' => 'Beautiful woodland trail with wildlife', 'rating' => 4.7, 'difficulty' => 'Easy', 'distance' => '3 miles', 'image' => 'https://images.unsplash.com/photo-1469854523086-cc02fe5d8800?w=500&h=400&fit=crop'],
            ['id' => 2, 'name' => 'Rapidan River Trail', 'icon' => '💧', 'description' => 'Scenic river walk with picnic areas', 'rating' => 4.8, 'difficulty' => 'Easy', 'distance' => '2 miles', 'image' => 'https://images.unsplash.com/photo-1439066615861-d1af74d74000?w=500&h=400&fit=crop'],
            ['id' => 3, 'name' => 'Mountain Ridge Trail', 'icon' => '⛰️', 'description' => 'Challenging hike with panoramic views', 'rating' => 4.9, 'difficulty' => 'Hard', 'distance' => '8 miles', 'image' => 'https://images.unsplash.com/photo-1506905925346-21bda4d32df4?w=500&h=400&fit=crop'],
            ['id' => 4, 'name' => 'Forest Loop Trail', 'icon' => '🌲', 'description' => 'Moderate loop through old growth forest', 'rating' => 4.6, 'difficulty' => 'Moderate', 'distance' => '5 miles', 'image' => 'https://images.unsplash.com/photo-1441974231531-c6227db76b6e?w=500&h=400&fit=crop'],
            ['id' => 5, 'name' => 'Waterfall Trail', 'icon' => '💦', 'description' => 'Trek to hidden waterfall', 'rating' => 4.8, 'difficulty' => 'Moderate', 'distance' => '4 miles', 'image' => 'https://images.unsplash.com/photo-1511632765486-a01980e01a18?w=500&h=400&fit=crop'],
            ['id' => 6, 'name' => 'Heritage Farm Trail', 'icon' => '🌾', 'description' => 'Walking tour of historic farmlands', 'rating' => 4.5, 'difficulty' => 'Easy', 'distance' => '1.5 miles', 'image' => 'https://images.unsplash.com/photo-1501594907352-04cda38ebc29?w=500&h=400&fit=crop'],
        ];

        return Inertia::render('Categories/NatureCategory', [
            'trails' => $trails,
        ]);
    }

    public function shopping()
    {
        $shops = [
            ['id' => 1, 'name' => 'Mountain Crafts Gallery', 'icon' => '🎨', 'description' => 'Local artisan crafts and handmade items', 'rating' => 4.7, 'type' => 'Local Crafts', 'image' => 'https://images.unsplash.com/photo-1441986300917-64674bd600d8?w=500&h=400&fit=crop'],
            ['id' => 2, 'name' => 'Vintage Heritage', 'icon' => '🏺', 'description' => 'Antique and vintage collectibles', 'rating' => 4.6, 'type' => 'Antique Shops', 'image' => 'https://images.unsplash.com/photo-1567538096630-e0c55bd6374c?w=500&h=400&fit=crop'],
            ['id' => 3, 'name' => 'Greene County Market', 'icon' => '🏪', 'description' => 'Farm fresh produce and local goods', 'rating' => 4.8, 'type' => 'Local Market', 'image' => 'https://images.unsplash.com/photo-1488459716781-6918f33427d1?w=500&h=400&fit=crop'],
            ['id' => 4, 'name' => 'Blue Ridge Books', 'icon' => '📚', 'description' => 'Independent bookstore with local authors', 'rating' => 4.7, 'type' => 'Books', 'image' => 'https://images.unsplash.com/photo-1512820790803-83ca734da794?w=500&h=400&fit=crop'],
            ['id' => 5, 'name' => 'Artisan Studio', 'icon' => '🖼️', 'description' => 'Contemporary art and sculptures', 'rating' => 4.9, 'type' => 'Art Gallery', 'image' => 'https://images.unsplash.com/photo-1541961017774-22349e4a1262?w=500&h=400&fit=crop'],
            ['id' => 6, 'name' => 'Homespun Store', 'icon' => '🧵', 'description' => 'Quilts, textiles and handmade goods', 'rating' => 4.5, 'type' => 'Local Crafts', 'image' => 'https://images.unsplash.com/photo-1572635196237-14b3f281503f?w=500&h=400&fit=crop'],
        ];

        return Inertia::render('Categories/ShoppingCategory', [
            'shops' => $shops,
        ]);
    }

    public function heritage()
    {
        $heritage = [
            ['id' => 1, 'name' => 'Greene County Historical Museum', 'icon' => '🏛️', 'description' => 'Exhibits spanning from Native Americans to modern era', 'rating' => 4.6, 'type' => 'Museum', 'established' => '1952', 'image' => 'https://images.unsplash.com/photo-1511632765486-a01980e01a18?w=500&h=400&fit=crop'],
            ['id' => 2, 'name' => 'Civil War Battlefield Park', 'icon' => '⚔️', 'description' => 'Historic Civil War site with interpretive trails', 'rating' => 4.7, 'type' => 'Historic Site', 'established' => '1865', 'image' => 'https://images.unsplash.com/photo-1501594907352-04cda38ebc29?w=500&h=400&fit=crop'],
            ['id' => 3, 'name' => 'Heritage Art Gallery', 'icon' => '🎭', 'description' => 'Contemporary and historical artwork', 'rating' => 4.8, 'type' => 'Art Gallery', 'established' => '2005', 'image' => 'https://images.unsplash.com/photo-1541961017774-22349e4a1262?w=500&h=400&fit=crop'],
            ['id' => 4, 'name' => 'Old Town Historic District', 'icon' => '🏘️', 'description' => 'Walking tour of preserved colonial buildings', 'rating' => 4.7, 'type' => 'Historic Site', 'established' => '1768', 'image' => 'https://images.unsplash.com/photo-1480562101562-b85ac3a98a3e?w=500&h=400&fit=crop'],
            ['id' => 5, 'name' => 'Native American Heritage Center', 'icon' => '🪶', 'description' => 'Exhibits on indigenous peoples of region', 'rating' => 4.8, 'type' => 'Museum', 'established' => '1998', 'image' => 'https://images.unsplash.com/photo-1465310477141-6fb93167a273?w=500&h=400&fit=crop'],
            ['id' => 6, 'name' => 'Architectural Heritage Tour', 'icon' => '🏗️', 'description' => 'Guided tours of historic buildings', 'rating' => 4.6, 'type' => 'Historic Site', 'established' => '1975', 'image' => 'https://images.unsplash.com/photo-1511632765486-a01980e01a18?w=500&h=400&fit=crop'],
        ];

        return Inertia::render('Categories/HeritageCategory', [
            'heritage' => $heritage,
        ]);
    }
}
