# 🌳 Explore Greene County - موقع سياحي احترافي

> **موقع رسمي لمركز زوار مقاطعة Greene County في فرجينيا**

## 🎯 نظرة عامة

موقع إلكتروني سياحي حديث وجذاب يهدف إلى:
- 📍 عرض المعالم والجذب السياحية
- 🍽️ ترويج المطاعم والخدمات الغذائية
- 📅 إعلان الفعاليات والأحداث
- 🏙️ استكشاف المدن والمجتمعات
- 👥 جمع تقييمات وتجارب الزوار
- 📰 نشر أخبار وتحديثات سياحية

## 🛠️ التقنيات المستخدمة

```
Backend:        Laravel 12.44.0 (PHP 8.2)
Frontend:       Vue 3.5.26 + TypeScript
Bridge:         Inertia.js 2.3.4
Styling:        Tailwind CSS 3.4.19
Build Tool:     Vite 7.0.7
Database:       MySQL (قريباً)
Authentication: Laravel Sanctum 4.2.1
```

## 📁 بنية المشروع

```
exploregreene/
├── app/
│   ├── Http/Controllers/Web/Landing/    # Landing Controllers
│   ├── Services/                         # Business Logic
│   │   ├── ContentService.php
│   │   ├── VisitorInfoService.php
│   │   ├── EventService.php
│   │   └── BookingService.php
│   └── Models/                           # Eloquent Models (قريباً)
│
├── config/
│   ├── attractions.php                   # Static attractions data
│   ├── events.php                        # Static events data
│   ├── cities.php                        # Static cities data
│   └── content.php                       # Static content data
│
├── resources/
│   └── js/
│       ├── Components/                   # Reusable Vue components
│       │   ├── Header.vue
│       │   ├── Footer.vue
│       │   ├── HeroSearch.vue
│       │   ├── CategoryGrid.vue
│       │   ├── ListingCard.vue
│       │   ├── CityCard.vue
│       │   ├── EventCard.vue
│       │   ├── TestimonialCard.vue
│       │   ├── NewsCard.vue
│       │   └── NewsletterBox.vue
│       │
│       ├── Layouts/
│       │   └── AppLayout.vue            # Master layout
│       │
│       └── Pages/Landing/               # Landing pages
│           ├── Home.vue
│           ├── Visit.vue
│           ├── Explore.vue
│           ├── Attractions.vue
│           ├── Events.vue
│           ├── Cities.vue
│           └── Contact.vue
│
└── routes/
    └── web.php                          # Landing routes

```

## 🚀 البدء السريع

### التثبيت
```bash
# تثبيت المتطلبات
composer install
npm install

# نسخ ملف البيئة
cp .env.example .env

# توليد مفتاح التطبيق
php artisan key:generate

# تشغيل في وضع التطوير
npm run dev
php artisan serve
```

### البناء للإنتاج
```bash
# تجميع الأصول
npm run build

# إعداد قاعدة البيانات (عند الحاجة)
php artisan migrate
```

## 📋 الصفحات الرئيسية

| الصفحة | الرابط | الوصف |
|--------|--------|-------|
| الرئيسية | `/` | صفحة رئيسية شاملة مع جميع الأقسام |
| الزيارة | `/visit` | دليل شامل لزيارة المقاطعة |
| الاستكشاف | `/explore` | استكشاف الأنشطة والجذب السياحية |
| الجذب | `/attractions` | قائمة شاملة بالمعالم السياحية |
| الفعاليات | `/events` | أحداث وفعاليات قادمة |
| المدن | `/cities` | المدن والمجتمعات المحلية |
| التواصل | `/contact` | معلومات الاتصال والاستفسارات |

## ✨ المميزات

### التصميم
- ✅ **Responsive Design** - يعمل على جميع الأجهزة
- ✅ **Modern UI** - واجهة مستخدم عصرية وجذابة
- ✅ **Smooth Animations** - تأثيرات واحترافية
- ✅ **Accessibility** - معايير WCAG للوصول

### الأداء
- ✅ **Fast Loading** - تحسينات سرعة التحميل
- ✅ **Lazy Loading** - تحميل الصور عند الحاجة
- ✅ **Code Splitting** - تقسيم الكود للأداء
- ✅ **Caching** - تخزين مؤقت ذكي

### SEO
- ✅ **Meta Tags** - وسوم meta مخصصة لكل صفحة
- ✅ **Semantic HTML** - معايير HTML دلالية
- ✅ **SSR Ready** - جاهز للـ Server-Side Rendering
- ✅ **Structured Data** - بيانات منظمة (Schema.org)

### الأمان
- ✅ **CSRF Protection** - حماية من تزييف الطلبات
- ✅ **XSS Prevention** - حماية من هجمات XSS
- ✅ **HTTPS Ready** - جاهز للاتصالات الآمنة

## 📊 الإحصائيات

- **Pages:** 7 صفحات رئيسية
- **Components:** 10 مكونات Vue قابلة لإعادة الاستخدام
- **Static Data:** 4 ملفات config مع بيانات وصفية
- **Services:** 4 classes للمنطق التجاري
- **Responsive:** 3 breakpoints (Mobile, Tablet, Desktop)

## 🔄 دورة الحياة التطويرية

### المرحلة 1: ✅ الواجهات الأمامية (اكتملت)
- صفحات Landing شاملة
- مكونات Vue احترافية
- بيانات ثابتة وصحيحة

### المرحلة 2: ⏳ قاعدة البيانات والـ Backend
- Models و Migrations
- Admin Panel
- API Endpoints

### المرحلة 3: ⏳ التكامل والـ APIs
- تكامل مع أنظمة خارجية
- APIs للتطبيقات الخارجية
- التطبيقات الموبايل

### المرحلة 4: ⏳ الصيانة والتطوير
- تحسينات مستمرة
- إضافة ميزات جديدة
- دعم المستخدمين

## 📝 الملاحظات

### التطوير المستقبلي
- [ ] إضافة نظام تسجيل المستخدمين
- [ ] نظام الحجوزات والتذاكر
- [ ] نظام التقييمات والتعليقات
- [ ] نظام إدارة المحتوى (CMS)
- [ ] تطبيق موبايل (React Native/Flutter)
- [ ] Chatbot ذكي

### نصائح للمطورين
- استخدم `config()` للوصول للبيانات الثابتة
- أضف بيانات جديدة في ملفات config
- أنشئ components قابلة لإعادة الاستخدام
- اتبع نمط Service للمنطق التجاري

## 📚 المراجع

- [Laravel Documentation](https://laravel.com/docs/12.x)
- [Vue 3 Documentation](https://vuejs.org/)
- [Inertia.js Documentation](https://inertiajs.com/)
- [Tailwind CSS Documentation](https://tailwindcss.com/docs)

## 👥 الفريق

تم تطويره باستخدام أفضل الممارسات والمعايير الحديثة.

## 📞 التواصل

للاستفسارات والدعم:
- 📧 Email: info@exploregreene.com
- 📱 Phone: (434) 985-5202
- 📍 Address: Greene County Visitor Center, Stanardsville, VA

---

**آخر تحديث:** 2025-12-30  
**الإصدار:** 1.0.0  
**الحالة:** ✅ جاهز للإنتاج

---

<p align="center">
  Made with ❤️ for Greene County Tourism
</p>
